# Generated Python Strategy for: PlayerB (meta)
# Run Index: 4
# Primary LLM: DeepSeek-V3 (deepseek-ai/DeepSeek-V3-0324) Provider: novita
def PlayerB_DeepSeek_V3_MetaAgent_Run4_Iter1(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Initial move: Cooperate
    if not my_history:
        return "C"
    
    # Heuristic analysis of opponent's code
    opponent_code = opponent_program_code.lower()
    
    # Check for always_cooperate or always_defect
    if "always_cooperate" in opponent_code or "return 'c'" in opponent_code or "return c" in opponent_code:
        return "C"
    if "always_defect" in opponent_code or "return 'd'" in opponent_code or "return d" in opponent_code:
        return "D"
    
    # Check for Tit-for-Tat-like strategies
    tit_for_tat_keywords = ["opp_history[-1]", "opp_history[len(opp_history)-1]", "return opp_history[-1]"]
    if any(keyword in opponent_code for keyword in tit_for_tat_keywords):
        return opp_history[-1] if opp_history else "C"
    
    # Check for random strategies
    if "random.choice" in opponent_code or "random.choose" in opponent_code:
        return "D"  # Defect against random opponents
    
    # Check for suspicious or complex code (long or contains certain keywords)
    lines = opponent_program_code.split('\n')
    if len(lines) > 20 or "make_internal_llm_call" in opponent_code:
        return "D"  # Be cautious with complex or recursive agents
    
    # Default to Tit-for-Tat if no clear heuristic matches
    return opp_history[-1] if opp_history else "C"